//AIM: To design pyramidal horn antenna in E-plane and H-plane.
//Software version Scilab 5.5.2
//OS windows 7
clear;
clc;
//Consider the E-plane aperture aE=10λ is fed with a rectangular waveguide with
//TE10 mode. Let δ =0.2λ in the E-plane and 0.375 in the H-plane.
//We will compute :
//(i) Length of horn antenna,H-plane aperture,flare angle for E-plane & H-plane.
//(ii) Half power beamwidth in E plane & H-plane.
//(iii) First null beamwidth in E-plane and H-plane.
//(iv) Directivity in dB

lambda=1;//Assumption
aE=10*lambda;
delE=0.2*lambda;
delH=0.375*lambda;

//To find the length of horn 

Length=(aE*aE)/(8*delE);
disp('λ',Length,'Length of the horn=');

//To find the H-plane aperture

aH=sqrt(Length*8*delH);
disp('λ',aH,'aH=');

//To compute flare angles theta_E and theta_H
// We require the values of aE/2 and aH/2

b=(aE/2)/Length;
c=(aH/2)/Length;
e=2*(atan(b))*180/3.14;
disp('degrees',e,"thetha_E in degree=");

f=2*(atan(c))*180/3.14;
disp('degrees',f,"thetha_H in degree=");

//To calculate half power beamwidth in both planes

HPBWE=56/aE;
disp('degrees',HPBWE,"HPBW(E-plane) in degree=");

HPBWH=67/aH;
disp('degrees',HPBWH,"HPBW(H-plane) in degree=");

// To calculate first null beamwidth in both planes

FNBWE=115/aE;
disp('degrees',FNBWE,"FNBW(E-plane) in degree=");

FNBWH=172/aH;
disp('degrees',FNBWH,"FNBW(H-plane) in degree=");

//To calculate Directivity

Ap=aE*aH;
disp('λ^2',Ap,"Directivity Ap=");

D=10*log10(7.5*Ap);
disp('dB',D,"Directivity Ap in dB=");
