//AIM: Design a lossless horn antenna with directivity 20dB at a frequency of 10 GHz
//Software version Scilab 5.5.2
//OS windows 7
clc;
clear;
//We will calculate :
//1. the maximum effective aperture
//2. the maximum power received when incident power density is 2*10^-3(W/m^2)
clc;
f=10*10^9;//Frequency
c=3*10^8;//Speed of light
Do=20;//Directivity (in dB)
do=10^(Do/10)
disp(do,"Dimensionless directivity=")
lambda=c/f;//Computing the wavelength
disp('m',lambda,"lambda=")
//Computing the maximum effective aperture Aem :
Aem=((lambda^2)*do)/(4*%pi);
disp('m^2',Aem,"Maximum effective aperture,Aem=")
//Computing the maximum power received: Pr
disp('Hz',f,"Frequency=")
Wi=2*10^-3;//Incident power density
Pr=Aem*Wi;
disp('W',Pr,"Maximum power received, Pr=")
