//AIM: Compute the parameter(power) of the receiving antenna for polarization
//match condition
//Software version Scilab 5.5.2
//OS windows 7

clc; 
clear;
//Assume that the transmitting and receiving antennas are operating at 3GHz 
//with gain 25dB and 20dB respectively,transmitter power is 100 Watts 
//and the distance between the antennas is 500 m
f=3*(10^9);//in GHz
disp('Hz',f,"Frequency=")
c=3*(10^8);//in m/s
lambda=c/f;//in meters
disp('m',lambda,"lambda=")
r=500;//in meters
Pt=100;// in Watts
Gtdb=25;//in dB
Grdb=20;//in dB
Gt=10^(Gtdb/10);
disp(Gt,"Gt=")
Gr=10^(Grdb/10);
disp(Gr,"Gr=")
PLF=1;//Polarization match.
Pr=Pt*((lambda/(4*%pi*r))^2)*Gt*Gr*(PLF^2);
disp('W',Pr,"Power delivered to the receiver =")
