//AIM:Determination of  voltage induced in a loop antenna that has 12 turns.
//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;

//Let the field strength of the incident waves be 100 uV/m & frequency of 10 MHz.
//The loop is oriented such that its plane is in the direction of waves.
//Assume area is 1 (metre)^2

N=12;// Number of turns
f=10*(10^6);//Frequency in Hz
disp('Hz',f,"Frequency=")
c=3*10^8;//Speed of light
lambda=c/f;//Wavelength in metres
disp('m',lambda,"Wavelength (lambda)=");
A=1;//Area in m^2
Erms=100*(10^(-6));// in uV/m
theta=0;//as plane of loop is in the direction of wave angle is 0 degree
Vrms=((2*%pi*A*N.*cos(theta))/lambda)*Erms
disp('V/m',Vrms,"Vrms=");
