clear;
clc;

// Illustration 6.3
// Page: 328

printf('Illustration 6.3 -  Page: 328\n\n');

// solution
//*****Data*****//
//   n-heptane - a    n-octane - b
P = 1; // [bar]

// Basis:
F = 100; //  [mole]
// Therefore
D = 60; // [mole]
W = 40; // [mole]
xf = 0.5;
// Substituting in equation 6.11 yields
// log(F/W) = Integration of dx/(y_star-x) from xw to 0.50

// The equilibrium-distribution data for this system can be generated by calculating the liquid composition (x = xw) at the dew point (D = l.O).for different feed  // compositions (y_star = z).
y_star = [0.5 0.55 0.60 0.65 0.686 0.70 0.75];
x = [0.317 0.361 0.409 0.460 0.5 0.516 0.577];
for i = 1:7
    f(i) = 1/(y_star(i)-x(i));
end

area = [0.317 5.464;0.361 5.291;0.409 5.236;0.460 5.263;0.5 5.376;0.516 5.435;0.577 7.78];
// LHS of equation 6.11
a = log(F/W);

scf(4);
plot(area(:,1),area(:,2));
xgrid();
legend('area under curve');
xlabel("x");
ylabel("1/(y_satr-x)");

// When the area becomes equal to 0.916, integration is stopped; this occurs at 
xw = 0.33; // [mole fraction of heptane in residue]
yd =( F*xf-W*xw)/D; // [mole fraction of heptane]
printf("The composition of the composited distillate and the residue are %f and %f respectively\n\n",yd,xw); 