clear;
clc;
close;
disp("y[n]-1/2*y[n-1]=x[n]+1/2*x[n-1]");
disp("taking fourier transform on both sides");
disp("H(w)=Y(w)/X(w)=(1+1/2*e^-j*w)/(1-1/2*e^-j*w)");
w=-10:0.1:10;
Hw=(1+(1/2)*%e^(-%i*w))./(1-(1/2)*%e^(-%i*w));
figure
subplot(2,1,1)
plot(w,Hw);
xtitle('H(w)','w')
n=-10:10;
h=(1/(2*%pi))*Hw*exp(%i*w'*n);
subplot(2,1,2)
plot2d3(n,h)
xtitle('h[n]','n')
plot(n,h,'r.')
x=cos(%pi*n/2);
figure
subplot(2,1,1)
plot2d3(n,x);
xtitle('x[n]','n')
plot(n,x,'r.')
y=convol(x,h);
subplot(2,1,2)
plot2d3(n,y(11:31))
xtitle('y[n]','n')
plot(n,y(11:31),'r.')