// Y.V.C.Rao ,1997.Chemical Engineering Thermodynamics.Universities Press,Hyderabad,India.

//Chapter-5,Example 17,Page 183
//Title: Device and its feasibility
//================================================================================================================
clear 
clc

//INPUT
T_i=150;//temperature of saturated steam taken up by the device in degree celsius
T_e=200;//temperature of superheated steam delivered by the device in degree celsius
P_e=0.2;//pressure of superheated steam delivered by the device in MPa
me2=0.949;//mass of superheated steam leaving the device in kg
me1=0.051;//mass of saturated liquid leaving the device in kg
T_liq=100;//temperature of saturated liquid leaving the device in degree celsius
mi=1;//mass of saturated steam fed to the device in kg

//CALCULATION
//From steam tables corresponding to T_i
hi=2745.4//enthalpy of saturated vapour in kJ/kg
si=6.8358;//entropy of saturated vapour in kJ/kgK

//For saturated liquid at T_liq
he1=419.06;//enthalpy of saturated liquid in kJ/kg
se1=1.3069;//entropy of saturated vapour in kJ/kgK

//For superheated steam at P_e and T_e
he2=2870.5;//enthalpy of superheated steam in kJ/kg
se2=7.5072;//entropy of superheated steam in kJ/kgK

//Test to see if the device obeys the first law of thermodynamics
//Application of the first law of thermodynamics to the flow device gives: mi*hi=(me1*he1)+(me2*he2)
LHS=mi*hi;
RHS=(me1*he1)+(me2*he2);

//Test to see if the device obeys the second law of thermodynamics
//Application of the second law of thermodynamics to the flow device gives: (Ne1*se1)+(Ne2*se2)-(Ni*si)>|0
S_G=(me1*se1)+(me2*se2)-(mi*si);

//OUTPUT
mprintf("\n The LHS of the equation applied to the flow device to check if the first law of thermodynamics is satisfied= %0.1f kJ\n",LHS);
mprintf("\n The RHS of the equation applied to the flow device to check if the first law of thermodynamics is satisfied=%0.1f kJ\n",RHS);
mprintf("\n The entropy generated by applying the second law of thermodynamics to the flow device=%0.4f kJ/kgK\n",S_G);
if int(LHS)== int(RHS)& S_G>0 | S_G==0 then
    mprintf("\n As the first and second law of thermodynamics are satisfied, the device is theoretically feasible \n");
else
mprintf("\n As both the first and second law or either the first or second law of thermodynamics are not satisfied, the device is not feasible \n");
end


//===============================================END OF PROGRAM===================================================
