clear;
clc;
printf("\t\t\tExample Number 3.8\n\n\n");
// heat generation with non uniform nodal elements 
// Example 3.8 (page no.-100-103)
// solution

k = 0.8;// [W/m degree celsius] thermal conductivity of glass
d = 0.003;// [m] thickness of layer of glass
x = 0.001;// [m] thickness of electric conducting strip
Tinf = 30;// [degree celsius] environment temperature 
h = 100;// [W/square meter degree celsius]
q1 = 40;// [W] heat generated by strips
q2 = 20;// [W] heat generated by strips
// the nodal network for a typical section of the glass is shown in figure. In this example we have not chosen dx = dy.
// because of symmetry T1 = T7 ,T2 = T6, etc, and we only need to solve the temperatures of 16 nodes. we employ  the resistance formulation. As shown, we have chosen 
dx = 0.005;// [m]
dy = 0.001;// [m]
A = 0.005;// [square meter]
// various resistances may now be calculated:

// for nodes 1,2,3,4:
one_by_Rm_p1 = k*dy/(2*dx);
one_by_Rm_m1 = one_by_Rm_p1;
one_by_Rn_p1 = h*A;
one_by_Rn_m1 = k*dx/dy;

// for nodes 8,9,10,11,15,16,17,18:
one_by_Rm_p2 = k*dy/(dx);
one_by_Rm_m2 = one_by_Rm_p2;
one_by_Rn_m2 = k*dx/dy;
one_by_Rn_p2 = one_by_Rn_m2;

// for nodes 22,23,24,25:
one_by_Rm_p3 = k*dy/(2*dx);
one_by_Rm_m3 = one_by_Rm_p3;
one_by_Rn_p3 = k*dx/dy;
one_by_Rn_m3 = 0;// [insulated surface]

// from the above resistances we may calculate the sum_one_by_Rij as
// nodes : 1,2,3,4:
sum_one_by_Rij1 = 4.66;
// nodes : 8,9,10,11,15,16,17,18:
sum_one_by_Rij2 = 8.32;
// nodes : 22,23,24,25:
sum_one_by_Rij3 = 4.16;
// the nodal equations are obtained from equation (3-31) 
// only node 4 has a heat generation term, Qi = 0 for all other nodes.
// the equations are listed below
// for node 1 : T8*one_by_Rn_m1+T2*one_by_Rm_p1+30*one_by_Rn_m1-sum_one_by_Rij1*T1 = 0;
// for node 4 : T5*one_by_Rm_p1+T3*one_by_Rm_m1+30*one_by_Rn_p1+T11*one_by_Rn_m1+Q-sum_one_by_Rij1*T4 = 0
// similar equations are obtained and we solve it by matrix method 
Z = [-4.58 0.08 0 0 4 0 0 0 0 0 0 0 0 0 0 0;
     0.08 -4.66 0.08 0 0 4 0 0 0 0 0 0 0 0 0 0;
     0 0.08 -4.66 0.08 0 0 4 0 0 0 0 0 0 0 0 0;
     0 0 0.16 -4.66 0 0 0 4 0 0 0 0 0 0 0 0;
     4 0 0 0 -8.16 0.16 0 0 4 0 0 0 0 0 0 0;
     0 4 0 0 0.16 -8.32 0.16 0 0 4 0 0 0 0 0 0;
     0 0 4 0 0 0.16 -8.32 0.16 0 0 4 0 0 0 0 0;
     0 0 0 4 0 0 0.32 -8.32 0 0 0 4 0 0 0 0;
     0 0 0 0 4 0 0 0 -8.16 0.16 0 0 4 0 0 0;
     0 0 0 0 0 4 0 0 0.16 -8.32 0.16 0 0 4 0 0;
     0 0 0 0 0 0 4 0 0 0.16 -8.32 0.16 0 0 4 0;
     0 0 0 0 0 0 0 4 0 0 0.32 -8.32 0 0 0 4;
     0 0 0 0 0 0 0 0 4 0 0 0 -4.08 0.08 0 0;
     0 0 0 0 0 0 0 0 0 4 0 0 0.08 -4.16 0.08 0;
     0 0 0 0 0 0 0 0 0 0 4 0 0 0.08 -4.16 0.08;
     0 0 0 0 0 0 0 0 0 0 0 4 0 0 0.16 -4.16];
C = [-15;-15;-15;-15-q2;0;0;0;0;0;0;0;0;0;0;0;0];
T1 = Z^(-1)*C;
printf("Nodes(1,2,3,4,8,9,10,11,15,16,17,18,22,23,24,25) temperature at 20 W/m respectively");
disp(T1);
Z1 = [-4.58 0.08 0 0 4 0 0 0 0 0 0 0 0 0 0 0;
     0.08 -4.66 0.08 0 0 4 0 0 0 0 0 0 0 0 0 0;
     0 0.08 -4.66 0.08 0 0 4 0 0 0 0 0 0 0 0 0;
     0 0 0.16 -4.66 0 0 0 4 0 0 0 0 0 0 0 0;
     4 0 0 0 -8.16 0.16 0 0 4 0 0 0 0 0 0 0;
     0 4 0 0 0.16 -8.32 0.16 0 0 4 0 0 0 0 0 0;
     0 0 4 0 0 0.16 -8.32 0.16 0 0 4 0 0 0 0 0;
     0 0 0 4 0 0 0.32 -8.32 0 0 0 4 0 0 0 0;
     0 0 0 0 4 0 0 0 -8.16 0.16 0 0 4 0 0 0;
     0 0 0 0 0 4 0 0 0.16 -8.32 0.16 0 0 4 0 0;
     0 0 0 0 0 0 4 0 0 0.16 -8.32 0.16 0 0 4 0;
     0 0 0 0 0 0 0 4 0 0 0.32 -8.32 0 0 0 4;
     0 0 0 0 0 0 0 0 4 0 0 0 -4.08 0.08 0 0;
     0 0 0 0 0 0 0 0 0 4 0 0 0.08 -4.16 0.08 0;
     0 0 0 0 0 0 0 0 0 0 4 0 0 0.08 -4.16 0.08;
     0 0 0 0 0 0 0 0 0 0 0 4 0 0 0.16 -4.16];
C1 = [-15;-15;-15;-15-q1;0;0;0;0;0;0;0;0;0;0;0;0];
T2 = Z1^(-1)*C1;
printf("\n\n Nodes(1,2,3,4,8,9,10,11,15,16,17,18,22,23,24,25) temperature at 40 W/m respectively");
disp(T2);
// we know the numerical value that the convection should have
// the convection losss at the top surface is given by 
qc1 = 2*h*[(dx/2)*(T1(1)-Tinf)+dx*(T1(2)+T1(3)-2*Tinf)+(dx/2)*(T1(4)-Tinf)];// [W] for 20W/m, the factor of 2 accounts for both sides of section
qc2 = 2*h*[(dx/2)*(T2(1)-Tinf)+dx*(T2(2)+T2(3)-2*Tinf)+(dx/2)*(T2(4)-Tinf)];// [W] for 40W/m
printf("\n\n the convection loss at the top surface is given by (for 20 W/m heat generation) %f W",qc1);
printf("\n\n the convection loss at the top surface is given by (for 40 W/m heat generation) %f W",qc2);
