// characteristic polynomial of matrix

clc
clear

// defining matrix
B = [7,1,-1; -11,-3,2; 18,2,-4];
disp('B =', B);

// finding characteristic polynomial
char_poly = round(poly(B, "x")); // poly for making a polynomial from matrix B
disp('The characteristic polynomial is', char_poly);

// finding eigenvalue
// finding roots of this polynomial will give eigenvalue
roots_poly = round(roots(char_poly)); // roots for finding roots of a polynomial
roots_poly = unique(roots_poly); // ignoring repeated roots
disp('The eigen values are');
for i = 1:length(roots_poly)
    disp(roots_poly(i));
end

// finding eigenspace for root 1
disp('for ',roots_poly(1));
equ_1 = roots_poly(1)*eye(3,3) - B; // -2*I - B // eye(3,3) to create (3,3) identity matrix

//  convert to row echelon form
equ_1_row = rref(equ_1); // rref to convert to row echelon form
disp('row echelon form is ', equ_1_row);

disp('The eigenspace is');
sol1 = [equ_1_row(1,3), equ_1_row(2,3), equ_1_row(2,2)];
disp(sol1);

// finding eigenspace for root 2
disp('for ',roots_poly(2));
equ_2 = roots_poly(2)*eye(3,3) - B; // -5*I - B

//  convert to row echelon form
equ_2_row = rref(equ_2); // rref to convert to row echelon form
disp('row echelon form', equ_2_row);

disp('The eigenspace is');
sol2 = [equ_2_row(2,3), equ_2_row(1,3), equ_2_row(2,2)];
disp(sol2);
