// determinant of matrix

clc
clear

A=[5,0,1,-2; 2,2,3,1; -1,3,2,5; 6,0,1,1];

// finding matrix of cofactors
cofactor = -coff(A)';
cofactor = horner(cofactor, 0);

disp('matrix of cofactors =', cofactor);

// cofactor expansion across row2
cofactor_expansion_row2 = A(2,1)*cofactor(2,1) + A(2,2)*cofactor(2,2) + A(2,3)*cofactor(2,3) + A(2,4)*cofactor(2,4);
disp('|A| from cofactor expansion across row2= ', cofactor_expansion_row2);

// cofactor expansion across column2
cofactor_expansion_column2 = A(1,2)*cofactor(1,2) + A(2,2)*cofactor(2,2) + A(3,2)*cofactor(3,2) + A(4,2)*cofactor(4,2);
disp('|A| from cofactor expansion across column2= ', cofactor_expansion_column2);

// cofactor expansion across column4
cofactor_expansion_column4 = A(1,4)*cofactor(1,4) + A(2,4)*cofactor(2,4) + A(3,4)*cofactor(3,4) + A(4,4)*cofactor(4,4);
disp('|A| from cofactor expansion across column4= ', cofactor_expansion_column4);
