// determinant criterion for matrix singularity

clc
clear

// defining matrix
A = [1,6; -3,5];

// corollary: Let A be an n × n matrix. Then rank(A) = n if and only if |A| ~= 0
if issquare(A) & det(A) ~= 0 then
    [row, col] = size(A);
    disp('Matrix rank is', row);
end

// equ1 for equation1
equ1 = [20; 9]; // RHS 
A_sol = -linsolve(A, equ1);
disp('Therefore, the solution is', A_sol);

// defining matrix
B = [1,5,1; 2,1,-7; -1,2,6];

// corollary: Let A be an n × n matrix. Then rank(A) = n if and only if |A| ~= 0
if issquare(B) & round(det(B)) ~= 0 then
    [row, col] = size(B);
    disp('Matrix rank is', row);
else
    [row, col] = size(B);
    printf('\nSince |B| = 0, rank < %d\n', row);
end

// equ2 for equation2
equ2 = [0; 0; 0]; // RHS 
B_sol = -linsolve(B, equ2);
disp('Therefore, the solution is', B_sol); // linsolve finds any solution to the equation. here it is a trivial solution
