// effect of row operations on determinant

clc
clear

// defining matrix A
A = [5,-2,1; 4,3,-1; 2,1,0];

disp('A =', A);
// calculating determinant of A
// 1. using direct command
// A_det = det(A);

// 2. using basketweaving method
A_det = A(1,1)*A(2,2)*A(3,3) + A(1,2)*A(2,3)*A(3,1) + A(1,3)*A(2,1)*A(3,2) - A(1,3)*A(2,2)*A(3,1) - A(1,1)*A(2,3)*A(3,2) - A(1,2)*A(2,1)*A(3,3);
disp('Determinant of A using basketweaving method is', A_det);

// defining matrix B1 -> formed by row operation row3 <- -3*row3 on A
B1=A;
B1(3,:) = -3*A(3,:);
disp('B1 =', B1);

// finding determinant of B1
B1_det = det(B1);
disp('Determinant of B1 is', B1_det);
if B1_det == -3*A_det then
    disp('Hence proved. |B1| = -3*|A|');
end

// defining matrix B2 -> formed by row operation row3 <- 2*row1 + row3 on A
B2=A;
B2(3,:) = 2*B2(1,:) + B2(3,:);
disp('B2 =', B2);

// finding determinant of B2
B2_det = round(det(B2)); // round for rounding off to nearest integer
disp('Determinant of B2 is', B2_det);
if B2_det == A_det then
    disp('Hence proved. |B2| = |A|');
end

// defining matrix B3 -> formed by row operation row1 ↔ row2
B3=A;
temp = B3(1,:);
B3(1,:) = B3(2,:);
B3(2,:) = temp;
disp('B3 =', B3);

// finding determinant of B3
B3_det = round(det(B3)); // round for rounding off to nearest integer
disp('Determinant of B3 is', B3_det);
if B3_det == -A_det then
    disp('Hence proved. |B1| = -|A|');
end
