// determinant by row reduction

clc
clear

A = [0,-14,-8; 1,3,2; -2,0,6];

disp('A =', A);

// reduce A to upper triangular form
// row1 ↔ row2
B1=A;
temp = B1(1,:);
B1(1,:) = B1(2,:);
B1(2,:) = temp;
disp('B1 =', B1);
disp('|B1| =', det(B1), '|A| =', det(A));

// row3 <- 2*row1 + row3
B2=B1;
B2(3,:) = 2*B2(1,:) + B2(3,:);
disp('B2 =', B2);
disp('|B2| =', det(B2), '|A| =', det(A));

// row2 <- -1/14 * row2
B3=B2;
B3(2,:) = -1/14 * B3(2,:);
disp('B3 =', B3);
disp('|B3| =', det(B3), '|A| =', det(A));

// row3 <- -6*row2 + row3
B=B3;
B(3,:) = -6*B(2,:) + B(3,:);
disp('B =', B);
disp('|B| =', det(B), '|A| =', det(A));

if B == triu(B) then
    disp('Matrix B is in upper triangular form');
end
