// finding determinant

clc
clear

// defining matrix
A =[5,-2,1; 0,4,-3; 2,-7,6];

disp('A =', A);

// finding submatrix
A_submatrix_3_1 = A(1:2, 2:3); //  delete all entries in the 3rd row and all entries in the 1st column
A_submatrix_3_2 = A(1:2, [1 3]); // delete all entries in the 3rd row and all entries in the 2nd column
A_submatrix_3_3 = A(1:2, 1:2); // delete all entries in the 3rd row and all entries in the 3rd column

// finding minors
// determinant of the submatrix
A_minor_3_1 = det(A_submatrix_3_1);
A_minor_3_2 = det(A_submatrix_3_2);
A_minor_3_3 = det(A_submatrix_3_3);

// finding cofactors
// cofactor = (-1)^index of element * minor
A_cofactor_3_1 = (-1)^(3+1)*det(A_minor_3_1);
A_cofactor_3_2 = (-1)^(3+2)*det(A_minor_3_2);
A_cofactor_3_3 = (-1)^(3+3)*det(A_minor_3_3);

disp('The corresponding cofactor with (3, 1) submatrix of A is', A_cofactor_3_1);
disp('The corresponding cofactor with (3, 2) submatrix of A is', A_cofactor_3_2);
disp('The corresponding cofactor with (3, 3) submatrix of A is', A_cofactor_3_3);

// finding determinant
// determinant = A(3,1)*cofactor of A(3,1) + A(3,2)*cofactor of A(3,2) + A(3,3)*cofactor of A(3,3)
determinant = A(3,1)*A_cofactor_3_1 + A(3,2)*A_cofactor_3_2 + A(3,3)*A_cofactor_3_3;
disp('Therefore determinant of A is', determinant);
