// ex 2.1 -> example 3 -> solving linear equations

clc
clear

// defining matrix
matrix1 = [3,1; -6,-2; 4,5];
equation_solution = [-5;10;8];

// matrix representation of equations
disp('Linear equation can be represented as matrix1,', matrix1, '=', equation_solution);

// two ways to solve problem
// 1. using linsolve
// 2. using Gaussian Elimination, row operations (book method)

// 1.
solution_to_equation = -linsolve(matrix1, equation_solution);
disp('Solutions to the linear equation is', solution_to_equation);

// or

// 2.

// concatenate matrices to create an augmented matrix
disp('2. Using Gaussian Elimination', 'The augmented matrix is');
// create an augmented matrix by appending solution to the equation to original matrix
matrix1_augmented = cat(2,matrix1,equation_solution);
disp(matrix1_augmented);

// position(1,1) is the pivot entry and that row of pivot position is pivot row
// make it equal to 1
// row operation row1 ← 1/3 *row1
disp('After row operation row1 ← 1/3 *row1');
matrix1_augmented(1,:) = matrix1_augmented(1,:)/3
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row2 ← 6*row1 + row2
disp('After row operation row2 ← 6*row1 + row2');
matrix1_augmented(2,:) = 6*matrix1_augmented(1,:) + matrix1_augmented(2,:);
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row3 ← -4*row1 + row3
disp('After row operation row3 ← -4*row1 + row3');
matrix1_augmented(3,:) = -4*matrix1_augmented(1,:) + matrix1_augmented(3,:);
disp(matrix1_augmented);

// position(2,2) is the pivot entry and that row of pivot position is pivot row
// make it equal to 1
// row operation row2 ↔ row3
disp('After row operation row2 ↔ row3');
temp = matrix1_augmented(3,:); // temp is used for intermediate for swapping
matrix1_augmented(3,:) = matrix1_augmented(2,:);
matrix1_augmented(2,:) = temp;
disp(matrix1_augmented);

// position(2,2) is the pivot entry and that row of pivot position is pivot row
// make it equal to 1
// row operation row2 ← 3/11 *row2
disp('After row operation row2 ← 3/11 *row2');
matrix1_augmented(2,:) = 3/11 *matrix1_augmented(2,:);
disp(matrix1_augmented);

// there is no entry below to target

// looking at the second equation
y = matrix1_augmented(2,3);
x = matrix1_augmented(1,3) - y*matrix1_augmented(1,2);
disp('Therefore x =', x, 'y =', y);

// displaying the solution
solution_to_equation = [x,y];
disp('Therefore the unique solution is', solution_to_equation);
