// gaussian elimination - with partial pivoting

clc
clear

matrix1 = [0.0006, -1, 1; 0.03, 30, -5; 0.04, 40, -7];
equation_solution = [10; 15; 19];

// matrix representation of equations
disp('Linear equation can be represented as matrix1,', matrix1, '=', equation_solution);

// two ways to solve problem
// 1. using linsolve
// 2. using Gaussian Elimination, row operations (book method)

// 1.
solution_to_equation = -linsolve(matrix1, equation_solution);
disp('Unique solutions to the linear equation is', solution_to_equation);

// or Gaussian Elimination gives inaccurate answer

// 2.
// create augmented matrix
matrix2 = cat(2, matrix1, equation_solution); // 1 for row, 2 for column
disp('augmented matrix', matrix2);

// row1 ↔ row3
temp = matrix2(1,:);
matrix2(1,:) = matrix2(3,:);
matrix2(3,:) = temp;
disp('row1 ↔ row3', matrix2);

// row1 ← (1/0.04)*row1
matrix2(1,:) = (1/0.04)*matrix2(1,:);
disp('row1 ← (1/0.04)*row1', matrix2);

// row2 ← −0.03*row1 + row2 and row3 ← -0.0006*row1 + row3
matrix2(2,:) = (-0.03)*matrix2(1,:) + matrix2(2,:);
matrix2(3,:) = (-0.0006)*matrix2(1,:) + matrix2(3,:);
disp('row2 ← −0.03*row1 + row2 and row3 ← -0.0006*row1 + row3', matrix2);

// row2 ↔ row3
temp = matrix2(2,:);
matrix2(2,:) = matrix2(3,:);
matrix2(3,:) = temp;
disp('row2 ↔ row3', matrix2);

// row2 ← (-1/1.6)*row2
matrix2(2,:) = (-1/1.6)*matrix2(2,:);
disp('row2 ← (-1/1.6)*row2', matrix2);

// row3 ← (1/0.25)*row3
matrix2(3,:) = (1/0.25)*matrix2(3,:);
disp('row3 ← (1/0.25)*row3', matrix2);

x3 = matrix2(3,4);
x2 = matrix2(2,4) - matrix2(2,3)*x3;
x1 = matrix2(1,4) - matrix2(1,3)*x3 - matrix2(1,2)*x2;
disp('(x1,x2,x3) =', x1, x2, x3);

disp('The correct solution is obtained by partial pivoting');
