// CONSTRUCTING SPECIAL BASES - Using the Simplified Span Method to Construct a Basis

clc
clear

A = [1,2,0,1; 3,1,5,-7; -2,4,-8,14];

// row reduce
reducedA=rref(A);

disp('row reduced A =', reducedA);

vector1=A(:,1);
vector2=A(:,2);
vector3=A(:,3);
vector4=A(:,4);

if (vector3 == 2*vector1-vector2) then
    if (vector4== -3*vector1 + 2*vector2) then
        disp('third and fourth vectors of S are linear combinations of the first two vectors'); 
        disp('[0, 5, −8] = 2[1, 3, −2]− [2, 1, 4]');
        disp('[1, −7, 14] = −3[1, 3, −2] + 2[2, 1, 4]');
        disp('therefore, redundant vectors can be eliminated from S without affecting span(S)')
    end
end

disp('Therefore, B is a subset of S that forms a basis for V = span(S), B=', [A(:,1)], [A(:,2)]);

dim = rank(reducedA);

disp('dim(V) =', dim);
