// characteristic polynomial of matrix

clc
clear

// defining matrix
A = [12,-51; 2,-11];
disp('A =', A);

// finding characteristic polynomial
char_poly = poly(A, "x"); // poly for making a polynomial from matrix A
disp('The characteristic polynomial is', char_poly);

// finding eigenvalue
// finding roots of this polynomial will give eigenvalue
roots_poly = roots(char_poly); // roots for finding roots of a polynomial
disp('The eigen values are');
for i = 1:length(roots_poly)
    disp(roots_poly(i));
end

// finding eigenspace for root 1
disp('For ',roots_poly(1));
equ_1 = roots_poly(1)*eye(2,2) - A; // 6*I - A // eye(2,2) to create (2,2) identity matrix

//  convert to row echelon form
equ_1_row = rref(equ_1); // rref to convert to row echelon form
disp('Row echelon form is ', equ_1_row);

disp('The eigenspace is');
sol1 = [-equ_1_row(1,2), equ_1_row(1,1)];
disp(sol1);

// finding eigenspace for root 2
disp('For ',roots_poly(2));
equ_2 = roots_poly(2)*eye(2,2) - A; // -5*I - A

//  convert to row echelon form
equ_2_row = rref(equ_2); // rref to convert to row echelon form
disp('Row echelon form', equ_2_row);

disp('The eigenspace is');
sol2 = [-equ_2_row(1,2), equ_2_row(1,1)];
disp(sol2);
