// ex 2.1 -> example 2 -> solving linear equations

clc
clear

// defining matrix
matrix1 = [5,-5,-15; 4,-2,-6; 3,-6,-17];
equation_solution = [40;19;41];

// matrix representation of equations
disp('Linear equation can be represented as matrix1,', matrix1, '=', equation_solution);

// two ways to solve problem
// 1. using linsolve
// 2. using Gaussian Elimination, row operations (book method)

// 1.

ordered_triplet = -linsolve(matrix1, equation_solution);
disp('1. Direct solution', 'Solutions to the linear equation is', ordered_triplet);

// 2.

// concatenate matrices to create an augmented matrix
disp('2. Using Gaussian Elimination', 'The augmented matrix is');
// create an augmented matrix by appending solution to the equation to original matrix
matrix1_augmented = cat(2,matrix1,equation_solution);
disp(matrix1_augmented);

// position(1,1) is the pivot entry and that row of pivot position is pivot row
// make it equal to 1
// row operation row1 ← 1/5 *row1
disp('After row operation row1 ← 1/5 *row1');
matrix1_augmented(1,:) = matrix1_augmented(1,:)/5
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row2 ← -4*row1 + row2
disp('After row operation row2 ← -4*row1 + row2');
matrix1_augmented(2,:) = -4*matrix1_augmented(1,:) + matrix1_augmented(2,:);
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row3 ← -3*row1 + row3
disp('After row operation row3 ← -3*row1 + row3');
matrix1_augmented(3,:) = -3*matrix1_augmented(1,:) + matrix1_augmented(3,:);
disp(matrix1_augmented);

// position(2,2) is the pivot entry and that row of pivot position is pivot row
// make it equal to 1
// row operation row2 ← 1/2 *row2
disp('After row operation row2 ← 1/2 *row2');
matrix1_augmented(2,:) = 1/2 *matrix1_augmented(2,:);
disp(matrix1_augmented);

// targeting entries - make entries below pivot entry equal to 0
// row operation row3 ← 3*row2 + row3
disp('After row operation row3 ← 3*row2 + row3');
matrix1_augmented(3,:) = 3*matrix1_augmented(2,:) + matrix1_augmented(3,:);
disp(matrix1_augmented);

// now position(3,3) is pivot entry
// it is already 1 and there is no entry below to target

// looking at the third equation
z = matrix1_augmented(3,4);
y = matrix1_augmented(2,4) - matrix1_augmented(2,3)*z;
x = matrix1_augmented(1,4) - y*matrix1_augmented(1,2) - z*matrix1_augmented(1,3);
disp('Therefore x =', x, 'y =', y, 'z =', z);

// displaying the ordered triplet
ordered_triplet = [x,y,z];
disp('Therefore the unique solution -  ordered triplet is', ordered_triplet);
