// Linear Combinations of Vectors

clc
clear

A=[5,10,12,33,19; 3,6,-4,-25,-11; 1,2,-2,-11,-5; 2,4,-1,-10,-4];

// reduced row echelon form
B=rref(A);
disp('reduced row echelon form of matrix=', B);

x=[4,8,-30,-132,-64];

if x == -1*A(1,:) + 3*A(2,:) + 4*A(3,:) + -2*A(4,:) then
    disp('x = − 1[5, 10, 12, 33, 19] + 3[3, 6, −4, −25, −11] + 4[1, 2, −2, −11, −5] − 2[2, 4, −1, −10, −4]');
    disp('therefore, x is in the row space of A');
end

if x == 4*B(1,:) + -30*B(2,:) then
    disp('x = 4[1, 2, 0, −3, −1] − 30[0, 0, 1, 4, 2]');
    disp('therefore, x is in the row space of B')
end
