// Reduced Row Echelon Form

clc
clear

matrix1=[4,-8,-2; 3,-5,-2; 2,-8,1];
matrix2=[2,1,4; 3,2,5; 0,-1,1];
equation_solution1=[0;0;0];
equation_solution2=[0;0;0];

disp(matrix1,'=',equation_solution1, "and", matrix2, "=", equation_solution2);

// Applying Gauss-Jordan row reduction to the coefficient matrices for these systems
matrix1=rref(matrix1);
matrix2=rref(matrix2);
disp('Applying Gauss-Jordan row reduction', matrix1, "and", matrix2);

// matrix1 has a nontrivial solution because only 2 of the 3 columns of the coefficient matrix are pivot columns
// matrix2 has only the trivial solution because all 3 columns of the coefficient matrix are pivot columns
sol1=[-matrix1(1,3), -matrix1(2,3), 1];

disp('Solution for matrix1 is multiple of', sol1);
disp('Matrix2 has only the trivial solution');

