// Reduced Row Echelon Form

clc
clear

A=[1,0,0,6; 0,1,0,-2; 0,0,1,3];
B=[1,0,2,0,-1; 0,1,3,0,4; 0,0,0,1,2; 0,0,0,0,0];
C=[1,4,0,-3,0; 0,0,1,2,0; 0,0,0,0,1];
disp('A=',A,'B=',B,'C=',C);

equation_solution_A=A(:,4);
A=A(1:3,1:3);

equation_solution_B=B(:,5);
B=B(1:4,1:4);

equation_solution_C=C(:,5);
C=C(1:3,1:4);

solA= -linsolve(A,equation_solution_A);
solB= -linsolve(B,equation_solution_B);
solC= -linsolve(C,equation_solution_C);

disp('Solution for A=', solA);
disp('Particular solution for B=', solB);
disp('Solution for C=', solC);
if isempty(solC) then
    disp('No solution');
end
