// ex 2.1 -> example 5 -> solving linear equations

clc
clear

// defining matrix
matrix1 = [3,1,7,2; 2,-4,14,-1; 5,11,-7,8; 2,5,-4,-3];
equation_solution = [13;-10;59;39];

// matrix representation of equations
disp('Linear equation can be represented as matrix1,', matrix1, '=', equation_solution);

// two ways to solve problem
// 1. using linsolve
// 2. using Gaussian Elimination, row operations (book method)

// 1.
solution_to_equation = -linsolve(matrix1, equation_solution);
if size(solution_to_equation) == 0 then
    disp('The given system of equations have no solutions');
else
   disp('One particular solution to the linear equation is', solution_to_equation); 
end

// or

// 2.


// concatenate matrices to create an augmented matrix
disp('2. Using Gaussian Elimination', 'The augmented matrix is');
// create an augmented matrix by appending solution to the equation to original matrix
matrix1_augmented = cat(2,matrix1,equation_solution);
disp(matrix1_augmented);

// simplifying
simplified_matrix = [1,1/3,7/3,2/3,13/3; 0,1,-2,1/2,4; 0,0,0,0,0; 0,0,0,-13/2,13];
disp('After simplifying the first two columns, augmented matrix becomes', simplified_matrix);

// row3 ↔ row4
temp = simplified_matrix(3,:);
simplified_matrix(3,:) = simplified_matrix(4,:);
simplified_matrix(4,:) = temp;
disp('row operation row3 ↔ row4 gives', simplified_matrix);

// Converting the pivot entry in the fourth column to 1
// row3 ← -2/13 * row3
simplified_matrix(3,:) = (-2/13)*simplified_matrix(3,:);
disp('row operation row3 ← -2/13 * row3 gives', simplified_matrix);

disp('Equation 3 gives x4 = −2, as the values for x1,x2,x3 are not uniquely determined, there are infinitely many solutions.');
