//Example 8.7
//Determine Volume, Temperature ,Total work and heat transfer and total entropy change
clear
clc
m = 2.5; //[kg]
V1 = 1.8; //[m^3]
p1 = 103; //[kPa]
T1 = 373; //[K]
p2 = 600; //[kPa]
n = 1.3;
R = (p1*V1)/(m*T1); //[kJ/kg K]  Gas constant
//(i) Determine the volume and temperature at the end of compression
// p1* (V1^n) = p2 * (V2^n)
V2 = V1*( (p1/p2)^(1/n) ); //[m^3] volume
disp('Volume at the end of compression',V2,'m^3')
//p2*V2 = m*R*T2
T2 = (p2*V2)/(m*R); //[K]  temperature
disp('Temperature at the end of compression',T2,'K')
//(ii) Determine the total work transfer
W1_2 = (p1*V1 - p2*V2)/(n-1); //[kJ]
V3 = V1; //[m^3]
W2_3 = p2*(V3 - V2); //[kJ]
W_tot = W1_2 + W2_3; //[kJ]  total work transfer
disp('Total work transfer =',W_tot,'kJ')
 //(iii) Determine total heat transfer
 Cv = 0.783; //[kJ/kg K]
 Cp = 1.005; //[kJ/kg K]
 Q1_2 = m*Cv*(T2 - T1) + W1_2; //[kJ]
 //(p2 V2)/T2 = (p3V3)/T3 & p3 = p2  & V3 = V1
 T3 = (T2*V1)/V2; //[K]
 Q2_3 = m*Cp*(T3 - T2); //[kJ]
 Q_tot = Q1_2 + Q2_3; //[kJ]
 disp('Total heat transferred =',Q_tot,'kJ')
 //(iv) Determine total change of entropy
S2_S1 = m*[Cv*log(T2/T1) + R*log(V2/V1)]; //[kJ/kg k] S2-S1
S3_S2 = m*[Cp*log(T3/T2) + R*log(V3/V2)]; //[kJ/kg K] S3-S2
del_S_tot = S2_S1 + S3_S2; //[kJ/kg K]total change in entropy
disp('Total change in entropy =',del_S_tot,'kJ/kg K')
//The answer provided in textbook is wrong
