//Example 8.6
//Determine specific volume of superheated vapor
clear
clc
p = 15; //[MPa]
T = 273 + 350; //[K] 
//From superheated steam tables at 15 MPa and 350°C
v = 0.011481; //[m^3/kg]  specific volume
//From data of water vapour
R = 0.4615; //[kJ/kg K]
pc = 22.06; //[MPa]
Tc = 647.1; //[K]
//(i) Determine specific volume of superheated vapor using ideal gas equation(pv = RT)
v_ideal = (R*T)/(p*1000); //[m^3/kg]
disp('Using ideal gas equation ,Specific volume = ',v_ideal,'m^3/kg')
//(ii) Determine specific volume using generalized compressibility chart
pr = p/pc; 
Tr = T/Tc; 
Z = 0.65; //From compressibility chart at pr and Tr
v_actual = Z *v_ideal; //[m^3/kg]  Z= actual v/ideal v
disp('Using generalized compressibility chart, Specific volume = ',v_actual,'m^3/kg')
error_in_case1 = ( (v_ideal - v)/v )*100; //[%] error in case 1
error_in_case2 = ( (v_actual - v)/v )*100; //[%] error in case 2
disp('Error in case 1 = ',error_in_case1,'%')
disp('Error in case 2 = ',error_in_case2,'%')
// The answer vary due to round off error
