//Example 8.5
//Calculate following question when heat is tranferred to 5 kg gas
clear
clc
m = 5; //[kg]
V1 = 0.3; //[m^3]
t1 = 273+10; //[°C]
t2 = 273 +120; //[°C]
Cp = 1.88; //[kJ/kg K]
Cv = 1.43; //[kJ/kg K]
R = Cp - Cv; // [kJ/kg K]  Gas constant
//(i) Calculate the final volume
p1 = m*R*t1/V1; //[kPa] 
p2 = p1; //[kPa] pressure is constant
V2 = m*R*t2/p2; //[m^3]  //final volume 
disp('Final Volume =',V2,'m^3')
//(ii) Calculate the heat transferred
Q1_2 = m*Cp*(t2-t1); //[kJ] heat transferred 
disp('Heat transferred = ',Q1_2,'kJ')
//(iii) Calculate the work done
W1_2 = p1*(V2 - V1); //[kJ] work done
disp('Work done = ',W1_2,'kJ')
//(iv) Calculate the changes in enthalpy and entropy
U1_2 = Q1_2 - W1_2; //[kJ] Change in internal energy
del_H = m*Cp*(t2 - t1); //[kJ]  Change in enthalpy
del_s = Cp*log(t2/t1) - R*log(p2/p1); //[kJ/K] Change in entropy
disp('Change in enthalpy = ',del_H,'kJ')
disp('Change in entropy = ',del_s,'kJ/K')
//(v) Calculate the gas constant
disp('Gas constant',R,'kJ/kg K')
//(vi) Calculate the molecular weight
R_bar = 8.314; //[kJ/kg K]
mu = R_bar/R; //[kg/kg mol]
disp('Molecular weight =',mu,'kg/kg mol')
