//Example 7.9
//Find isentropic efficiency of compressor and power required to drive compressor
clear
clc
m = 0.25; //[kg/s]
T1 = 273 + 17; //[k]
h1 = 290.16; //[kJ/kg] From table of ideal gas properties of air at 290 K
Pr1 = 1.2311; //From table of ideal gas properties of air at 290 K
T2 = 610; //[K]
h2 = 617.53; //[kJ/kg]  From tables of ideal gas properties at 610 K
P1 = 100; //[kPa]
P2 = 1000; //[kPa]
// Isentropic relation of ideal gas Pr2/Pr1 = P2/P1
Pr2 = (Pr1 * P2)/P1; 
h2_1 = 559.23; //[kJ/kg] At Pr2
//(i) Find isentropic efficiency of compressor
eta_c = ((h2_1 - h1)/(h2 - h1))*100; //[%]
disp('Isentropic efficiency of compressor = ',eta_c,'%')
//(ii) Find the power required to drive the compressor
W = m*(h2-h1); //[kW] Power required to run the compressor
disp('Power required to run the compressor = ',W,'kW')
