//Example 7.10
//Find Isentropic efficiency , Exit temperature and Actual exit velocity of air
clear
clc
T1 = 880; //[K]
T2 = 690; //[K]
P1 = 250; //[kPa]
P2 = 90; //[kPa]
//From tables of ideal gas specific heats
Cp_ave = 1.099; //[kJ/kg] Average specific heat
k = 1.354;
// Isentropic efficiency of nozzle = eta_N = (h1 - h2)/(h1 - h2_1) = (Cp_ave(T1-T2))/Cp_ave(T1 - T2_1)
T2_1 = T1*[(P2/P1)^( (k-1)/k)]; //[K] Exit temperature
eta_N = (T1 - T2)/(T1 - T2_1); //Isentropic efficiency of nozzle
V2_1 = sqrt(2*Cp_ave*(T1 - T2_1)*1000); //[m/s] Isentropic exit velocity of nozzle
V2 = V2_1*sqrt(eta_N); //[m/s] Actual exit velocity of air
disp(' Isentropic efficiency of nozzle = ',eta_N*100,'%')
disp(' Exit temperature = ',T2_1,'K')
disp(' Actual exit velocity of air = ',V2,'m/s')
//The answer vary due to round off error
