//Example 7.1
//Determine the increase in entropy of water
clear
clc
m1 = 1.5; // [kg]
t1 = 75;  // [°C]
T1 = 273 + t1; //[K]
m2 = 4;  // [kg]
t2 = 40;  // [°C]
T2 = 273 + t2; //[K]
Cpw = 4.2;  //[kJ/kg K]
t = 0; // [°C]
T = 273 + t; //[K]
m = m1+m2; //[kg]
E = m1*Cpw*(t1-t) + m2*Cpw*(t2-t); // total energy before mixing
// total energy after mixing = m*Cpw*(tf - t) 
tm = E/(m*Cpw); //[°C]  final equilibrium temperature of water
tf = 273 + tm; //[K] 
s1 = m1*Cpw*log(T1/T) + m2*Cpw*log(T2/T); //[kJ/kg K] Initial entropy of the system
disp('Initial entropy of the system, s1 = ',s1,'kJ/kg K')
s2 = m*Cpw*log(tf/T); // [kJ/kg K] Final entropy of the system
disp('Final entropy of the system, s2 = ',s2,'kJ/kg K')
del_s = s2 - s1; //[kJ/kg K]
disp('Increase in entropy of the system, del_s = ', del_s , 'kJ/kg K')
//The answer vary due to round off error