//Example 4.2
//Determine change in enthalpy, entropy, internal energy and volume
clear
clc
m = 15; //kg
//At state 1, water is saturated water, so from saturated steam table at 55°C
hf = 230.26; //  kJ/kg
h1 = hf; //  kJ/kg
vf = 0.00101;  // m^3/kg
v1 = vf; // m^3/kg
uf = 230.24;  // kJ/kg
u1 = uf; // kJ/kg
sf = 0.7679;  //  kJ/kg K
s1 = sf;  //  kJ/kg K
//At state 2, water becomes superheated, so from superheated steam tables at 16 bar and 350°C 
h2 = 3146.0; //  kJ/kg
v2 = 0.1745;  //m^3/kg
u2 = 2866.6;  //  kJ/kg
s2 = 7.0713;  // kJ/kg K
//(i) Determine the change in enthalpy
enthalpy = m*(h2-h1); //kJ
disp('Change in enthalpy = ' , enthalpy , 'kJ')
//(ii) Determine change in entropy
entropy = m*(s2-s1); // kJ/K
disp('Change in entropy = ',entropy,'kJ/K')
//(iii) Determine change in internal energy
del_U = m*(u2-u1); //kJ
disp('Change in internal energy = ', del_U,'kJ')
//(iv) Determine change in volume
del_V = m*(v2-v1); //m^3
disp('Change in volume = ',del_V, 'm^3')
