//Example 11.1
//Calculation on air standard Otto cycle
clear
clc
p1 = 1.1*100; //[kPa] pressure before start of compression
T1 = 323; //[K]  temperature before start of compression
eta_cycle = 0.45; // 45% 
q2 = 800; //[kJ/kg]
q1 = q2/(1 -eta_cycle); //[kJ/kg]  eta_cycle = 1 - q2/q1
//(i) Determine the work done per kg of air
W_net = eta_cycle*q1;//[kJ/kg]  net work done
disp('Work done per kg of air =',W_net,'kJ/kg')
//(iii) Determine the compression ratio
// eta_otto = eta_cycle = 1 - [1/(rk^(gama-1))] 
gama = 1.4; 
rk = [1/(1-eta_cycle)]^(1/(gama-1)); //compression ratio
disp('Compression ratio = ',rk)
//(iii) Determine the pressure and temperature at the end of compression
// rk =  (v1/v2)
//   T2/T1 = (v1/v2)^(gama-1) 
T2 = T1*((rk)^(gama-1)); //[K]
disp('Temperature at the end of compression=',T2,'K')
// Also p2/p1 = (v1/v2)^gama 
p2 = p1*(rk^gama); //[kPa]
disp('Pressure at the end of compression =',p2,'kPa')
//(iv) Determine the maximum pressure in the cycle
Cv = 0.783; 
T3 = (q1/Cv) + T2; //[K]  since q1 = Cv*(T3 - T2)
// For process 2-3 (p2*v2)/T2 = (p3*v3)/T3  where v2 = v3
p3 = (p2*T2)/T3; //[kPa]
disp('The maximum pressure in the cycle =',p3,'kPa')
// The answer provided in textbook is wrong
// eta_cycle given in question is 0.45 but in book it is taken as 0.50 then it is solved
