//Example 10.7
//Compute steam generation capacity  and rate of heat input and rejected
clear
clc
WT= 5600; //[kW]  Power of cogeneration plant
p1 = 40; //[bar]
t1 = 500; //[°C]
h1 = 3450; //[kJ/kg] at 40 bar and 500°C
h2 = 2700; //[kJ/kg]  enthalpy at state 2 , from mollier diagram by drawing line from 40 bar to 2 bar
h3 = 2230; //[kJ/kg] extending same line from 2 bar to 0.06 bar
// From saturated steam tables, at 0.06 bar
p4 = 0.06; //[bar]
h4 = 145; //[kJ/kg]  h4 = hf at 0.06 bar
v4 = 0.0010055; //[m^3/kg]
// From saturated steam tables at 2 bar
p6 = 2; //[bar]
h6 = 504; //[kJ/kg]  h6 = hf at 2 bar
v6 = 0.001061; //[m^3/kg]  v6 = vf at 2bar
// pump work
p5 = p1;
p7 = p1;
 wp1 = v4*(p5 - p4); //[kJ/kg]
 wp2 = v6*(p7 - p6); //[kJ/kg]
 h5 = h4 + wp1; //[kJ/kg]
 QH = 1.163*1000; //[kW]  Heat input
 m1 = QH/(h2 - h6); //[kg/s]  rate of steam flow 
 //(i) Compute steam generation capacity of boiler
 // WT = m*(h1 - h2) +(m - m1)*(h2 - h3)
 // final equation becomes =>  m = [WT + m1(h2 - h3)]/(h1 - h3)
 m = [WT + m1*(h2 - h3)]/(h1 - h3);  //[kg/s]  steam generation capacity of boiler
disp('Steam generation capacity of boiler =',m,'kg/s')
 //(ii) Compute rate of heat input to boiler
 h8 = h5; //[kJ/kg]
 Q1 = m*(h1 - h8); //[kW] Rate of heat input to boiler
 disp('Rate of heat input to the boiler =',Q1/1000,'MW')
 //(iii) Compute rate of heat rejected in the condenser
 Q2 = (m - m1)*(h3 - h4); //[kW]  Rate of heat rejected in condenser
 disp('Rate of heat rejected in the condenser =',Q2/1000,'MW')
