//Example 10.1
// Determine cycle efficiency and thermal efficiency in both case
clear
clc
//(i) Determine cycle efficiency
p1 = 2.5*10^3; //[kPa]
t1 = 300; //[K]
//From superheated stem tables at p1 and t1
h1 = 3009.6; //[kJ/kg]
s1 = 6.645; //[kJ/kg K]
p2 = 15; //[kPa]
//From saturated steam tables at p2
sf2 = 0.7549; //[kJ/kg K]
sfg2 = 7.252; //[kJ/kg K]
vf = 0.001014; //[m^3/kg]
hf2 = 225.94; //[kJ/kg]
hfg2 = 2373.2; //[kJ/kg]
s2 = s1; //[kJ/kg K]
x2 = [(s2 - sf2)/sfg2 ]; //[%]
 h2 = hf2 + x2*hfg2; //[kJ/kg]
 h3 = 225.94; //[kJ/kg]
 v3 = vf; //[m^3/kg]
 wp = v3*(p1 - p2); //[kJ/kg]
 h4 = wp + h3; //[kJ/kg]
 q1 = h1 - h4; //[kJ/kg]
 q2 = h2 - h3; //[kJ/kg]
 eta_cycle = [1 - (q2/q1)]*100; //[%] cycle efficiency
 disp('Cycle efficiency = ',eta_cycle,'%')
 //(ii) Determine thermal efficiency if steam is superheated to 500°C
 p1_1 = 2.5*1000; //[kPa]
 t1_1 = 500; //[°C]
 // at p1_1 and t1_1
h1_1 = 3462.8; //[kJ/kg]
s1_1 = 7.33; //[kJ/kg K]
s2_1 = s1_1; //[kJ/kg K]
x2_1 =  [(s2_1 - sf2)/sfg2]; //[%]
h2_1 = hf2 + x2_1*hfg2; //[kJ/kg]
q1_1 = h1_1 - h4; //[kJ/kg]
q2_1 = h2_1 - h3; //[kJ/kg]
eta_cycle_1 = [1 - (q2_1/q1_1)]*100; //[kJ/kg]
disp('Thermal efficiency if steam is superheated to 500°C  =',eta_cycle_1,'%')
//(iii) Determine thermal efficiency if boiler pressure is raised to 5 MPa and turbine inlet temperature is at 500°C
p1_2 = 5*1000; //[kPa]
t1_2 = 500; //[°C]
// at p1_2 and t1_2
h1_2 = 3434.7; //[kJ/kg]
s1_2 = 6.987; //[kJ/kg K]
s2_2 = s1_2; //[kJ/kg K]
x2_2 = [(s2_2 - sf2)/sfg2];
h2_2 = hf2 + x2_2*hfg2; //[kJ/kg]
wp_2 = v3*(p1_2 - p2); //[kJ/kg]
h4_2 = wp_2 + h3; //[kJ/kg]
q1_2 = h1_2 - h4_2; //[kJ/kg]
q2_2 = h2_2 - h3; //[kJ/kg]
eta_cycle_2 = [1 - (q2_2/q1_2)]*100; //[%]
disp('Thermal efficiency if boiler pressure is raised to 5MPa and turbine inlet temp is 500°C =',eta_cycle_2,'%')
//The answer vary due to round off error
