//Example 8.1
//Determine the pressure exerted by N2 gas
clear
clc
m = 10; //[kg]
V = 8; //[m^3]
T = 273 + 25; //[K]
R = 8.314;  //[kJ/mol K]   Gas constant
mu_N2 = 28; //[kg/mol]  Molecular weight of nitrogen
R_N2 = R/mu_N2; //[kJ/kg K]  Gas constant of N2
// (i) Determine the pressure exerted by N2 gas when the gas obeys idel gas equation
p = (m*R_N2*T)/V; //[kPa]  Pressure
disp('Pressure exerted by N2 gas when gas obeys ideal gas equation = ',p,'kPa')
//(ii) Determine the pressure exerted by N2 gas when the gas follows Vander waals equation
// Vander waals equation (p1 + a/v^2 )*(v - b) = R*T
n = m/mu_N2; //[mol] Number of moles
v = V/n; //[m^3/ kg mol]  Molar volume
a = 136.7; //[kN m^4/(kg mol)^2]
b = 0.0386; // [m^3/ kg mol]
p1 = ((R*T)/(v - b)) - a/v^2; //[kPa]  Pressure
disp('Pressure exerted by N2 gas when gas follows Vander waals equation',p1,'kPa')
