//Example 7.3
// Estimate the entropy change of the system
clear
clc
T1 = 273 + 25; //[K]
T2 = 273 + 0; //[K]
T3 = 273 + (-5); //[K]
m = 250; //[g]
Cp_water = 4.182; //[ J/g K]  Specific heat of water
Cp_ice = Cp_water/2; //[J/K]  Specific heat of ice
del_s_1 = m*Cp_water*log(T2/T1); //[J/K]  Entropy change of system when it is converted to ice from 25°C to 0°C 
// Answer of del_s_1 is given wrong as T2 is 298 and in book it is solved by taking T2 as 293
disp('Entropy change of the system(water) when it is converted to ice from 25°C to 0°C' , del_s_1,'J/K')
L = 335; //[J/g] latent heat of fusion at 0°C
Q = m*L; //[J]
del_s_2 = -Q/T2; //[J/K] entropy change of system when water freezes at 0°C
disp('Entropy change of the system (water) when water freezes at 0°C',del_s_2,'J/K')
del_s_3 = m*Cp_ice*log(T3/T2); //[J/K] entropy change when ice is formed from 0°C to -5°C
disp('Entropy change of system (water) when ice is formed from 0°C to -5°C',del_s_3, 'J/K')
del_s_total = del_s_1 + del_s_2 + del_s_3; //[J/K]
disp('Total entropy change of the system' , del_s_total, 'J/K')
//The answer for del_s_1 is provided wrong in textbook and value of del_s_2 and del_s_3 vary due to round off error due to this final answer vary
