// Example 5.3
//Calculate power and inlet and outlet cross sectional area
clear
clc
p1 = 1.5; //[bar]   
v1 = 0.9; // [m^3/kg]    specific volume while entering 
V1 = 8; //  [m/s]  
p2 = 8;  //[bar]
v2 = 0.145; //  [m^3/kg]    specific volume while leaving
V2 = 3.5; //[m/s]
z1_z2 = 0; //difference in height at inlet and outlet  (z1-z2)
heat_rate = -55;  //[kW]   rate at which cooling water absorbs heat from air
u1_u2 = -100; //[kJ]   difference in internal energy of air entering and leav
m = 30/60;  //  [kg/s]
//[h1-h2 = u1_u2 + (p1*v1 - p2*v2)*10^5 ] [kJ/kg]  (difference in enthalpy)
g = 9.8; // [m/s^2]  acceleration due to gravity
//(i) Calculate power required to drive the compressor
P  = m*[(u1_u2) + ((p1*v1-p2*v2)*10^5)/1000+ (V1^2 - V2^2)/(2*1000) + (z1_z2)*g ] + heat_rate; //[kW] 
disp('Power required to drive the compressor, P = ' , -P , 'kW')
//(ii) Calculate inlet and outlet cross sectional area
A1 = (m*v1)/V1; // [m^2]  
A2 = (m*v2)/V2; // [m^2]  
disp('Inlet cross sectional area, A1 = ' , A1 , 'm^2')
disp('Outlet cross sectional area, A2 = ' , A2 , 'm^2')
