//Example 14.1
//Determine amount of heat transferred and amount of steam added to air
clear
clc
Cp = 1.005; //[kJ/kg K]
R = 0.287; //[kJ/kg K]
h1 = 31.5; //[kJ/kg]
h2 = 37; //[kJ/kg]
T1 = 15; //[°C]
T2 = 20; //[°C]
ma = 1; //[kg/s]
//From the psychrometric chart in Figure EX 14.1
//ω1 = 0.00653;//[kg vapor/kg dry air]
//ω2 = ω1;//[kg vapor/kg dry air]
//ω3 = 0.01308; //[kg vapor/kg dry air]
pg1 = 1.757; //[kPa] p_sat of water at 15°C
pg3 = 3.1698; //[kPa] p_sat of water at 25°C
hg1= 2528.3; //[kJ/kg] Enthalpy of saturated water vapor at 15°C
hg2 = 2541; //[kJ/kg] Enthalpy of saturated water vapor at 22°C
φ = 0.60; 
pw1 = φ*pg1; //[kPa]
p1 = 101.325; //[kPa]
pa1 = p1 - pw1; //[kPa]
ω1 = (0.622*pw1)/(p1 - pw1);
ω2 = ω1;
h1 = Cp*T1 + ω1*hg1; //  kJ/kg dry air
h2 = Cp*T2 + ω2*hg2; //  kJ/kg dry air
//(i) Determine amount of heat transferred to air in heating section 
Q_in = ma*(h2 - h1); //[kJ/s]
disp('The amount of heat transferred to the air in the heating section = ',Q_in,'kJ/s')
//(ii) Determine amount of steam added to air
φ3 = 0.65;
p3 = p1; //[kPa]
ω3 = (0.622*φ3*pg3)/(p3 - φ3*pg3);
mw = ma*(ω3 - ω2); //[kg/s]
disp('The amount of steam added to air = ',mw,'kg/s')
