//Example 11.5
//Compute the efficiency of the cycle
clear
clc
p1 = 101.32; //[kPa]
T1 = 300; //[K]
T3 = 1023; //[K]
T5 = T3; //[K]
rp = 7; // rp = p2/p1 
eta_THP = 0.85; 
eta_TLP = 0.85;
eta_c = 0.80; 
gama = 1.4;
Cp = 1.005;
T2_1 = T1*[(rp)^((gama -1)/gama)]; //[K]  For process 1-2 T2_1/T1 = (rp)^(gama -1/gama)
T2 = [(T2_1 - T1)/eta_c] + T1;//[K]  eta_c = (T2_1 - T1)/(T2 - T1)
wc = Cp*(T2 - T1); //[kJ/kg]  work of compression
w_out_HP = wc; //[kJ/kg]   work output of high pressure turbine
T4 = T3 - w_out_HP/Cp; //[K]
T4_1 = T3 - (T3 - T4)/eta_THP; //[K]
p2 = rp*p1; //[kPa]
p3 = p2; //[kPa]
p4 = p3/[(T3/T4)^(gama/(gama -1))]; //For process3-4 
p5 = p4; //[kPa]
p6 = p1; //[kPa]
T6_1 = T5/[ (p5/p6)^( (gama -1)/gama) ]; //[K]  For process 5-6
T6 = T5 - eta_TLP*(T5 - T6_1); //[K]
w_out_LP = Cp*(T5 - T6); //[kJ/kg]
q1 = Cp*[(T3 - T2) + (T5 - T4)]; //[kJ/kg]
eta = (w_out_LP/q1)*100; //[%]
disp('The efficiency of the cycle = ',eta,'%')
// The answer provided in textbook is wrong
// Due to round off error  in initial calculations there is large difference in final solution
