//Example 9.8
//Estimate the exergy destroyed
clear
clc
mI = 10; //[kg]
CpI = 0.55; //[kJ/kg K]
t1_I = 300; //[°C]
T1_I = 273 + t1_I; //[K]
mw = 80; //[kg]
Cpw = 4.18; //[kJ/kg K]
t1_w = 27; //[kJ/kg K]
T1_w = 273 + 27; //[K]
T0 = 273 + 25; //[K]
// dQ = dW + dU and dU = 0 & dW = 0, therefore dQ = 0
// so the equation is, m1*Cp1*(tf - t1_1) + mw*Cpw*(tf - t1_w) = 0
tf = (mI*CpI*t1_I + mw*Cpw*t1_w)/(mI*CpI + mw*Cpw); //[ °C ] final equilibrium temperature
Tf = 273 + tf; //[K]
CvI = CpI; //[kJ/kg K]
E_loss_iron = mI*CvI*(T1_I - Tf) - mI*CvI*T0*log(T1_I/Tf); //[kJ]  exergy loss of iron block
Cvw = Cpw; //[kJ/kg K]
E_gain_water = mw*Cvw*(T1_w - Tf) - T0*mw*Cvw*log(T1_w/Tf);//[kJ] exergy gain of water
E_loss_system = E_loss_iron - E_gain_water; //[kJ]  exergy loss of system
disp('Exergy loss of the system =',E_loss_system,'kJ')
//The answer provided in textbook is wrong
