//Example 9.5
//Calculate following question on air expansion in  turbine
clear
clc
m = 1; //[kg]
Cv = 0.718; //[kJ/kg K]
T1 = 400; //[kPa]
T2 = 300; //[kPa]
p1 = 500; //[kPa]
p2 = 100; //[kPa]
p0 = 100; //[kPa]
T0 = 273 +17; //[K]
Cv = 0.718; //[kJ/kg K]
R = 0.287; 
v1 = 0.23; //[m^3/kg] At p1 and T1
v2 = 0.86; //[m^3/kg]  At P2 and T2
//(i) Calculate W_max(maximum work done)
//W_max = (u1 - u2) - T0(s1 - s2), where s2 - s1 = Cv*log(T2/T1) + R*log(v2/v1)
// (u1 - u2) = Cv(T1 - T2)
W_max = Cv*(T1 - T2) + T0*[ Cv*log(T2/T1) + R*log(v2/v1)];//[kJ]
disp('W_max = ',W_max,'kJ')
//(ii) Calculate W_act(actual work done)
//W_act = Q - del_U => -del_U = m*Cv*(T1 - T2)
W_act = m*Cv*(T1 - T2); //[kJ]
disp('W_act = ',W_act,'kJ')
//(iii) Calculate change in availability
Wu_max = W_max - p0*(v2 - v1); //[kJ] 
disp('Change in availability = ',Wu_max,'kJ')
//(iv) Calculate irreversibility
I = W_max - W_act; //[kJ]    irreversibility
disp('Irreversibility = ',I,'kJ')
//(v) Calculate second-law efficiency
eta_pi = (W_act/W_max)*100; //[%]
disp('Efficiency = ',eta_pi,'%')
//The answer vary due to round off error
