//Example 7.7
//Determine the entropy increase of the universe
clear
clc
m = 2.5; //[kg]
P = 200; //[kPa]
s_fg = 5.597; //[kJ/kg K] From steam tables for saturated water vapour at 200 kPA
del_s_sys = -(m*s_fg); //[kJ/K] for system
T = 273 +30; //[K]
h_fg = 2202; //[kJ/kg] From steam tables
Q = m*h_fg; //[kJ]
del_s_surr = Q/T; //[kJ/K]  for surrounding
del_s_univ = del_s_sys + del_s_surr; //[kJ/K]  for universe
disp('Entropy increase of the universe = ',del_s_univ,'kJ/K')
