// Example 6.4
//Determine ratio between heat transfer to circulating water and heat input to engine
clear
clc
COP_HP = 3.5;
// COP_HP = Q3/Wnet
// therefore Wnet = Q3/COP_HP  --eq1
eta_thermal = 0.25; 
// eta_thermal = Wnet/Q1
// therefore Wnet = eta_thermal*Q1  --eq2
// From eq1 & 2  [eta_thermal*Q1 = Q3/COP_HP]
// so Q3/Q1 = eta_thermal*COP_HP
Q3_1 = eta_thermal*COP_HP; // Q3/Q1
// Q2/Q1 = 1 - eta_thermal
Q2_1 = 1 - eta_thermal; 
Ratio = Q3_1 + Q2_1; // (Q3/Q1) + (Q2/Q1) = (Q3 + Q2)/Q1
disp('The ratio between heat transfer to circulating water and heat input to engine is ', Ratio)
