//Example 5.5
//Estimate velocity of air stream leaving the nozzle
clear
clc
p1 = 1.2; //[bar]
t1 = 30; //[°C]
V1 = 25; //[m/s]
p2 = 6; //[bar]
t2 = 230; //[°C]
V2 = 45; // [m/s]
Q = -80; // [kJ/s] Rate at which heat is removed from chamber
t4 = 30; // [°C]
t3 = (t1 + t2)/2;  //[°C]  Final temperature after mixing
// From tables of ideal gas properties of air
h1 = 303; //[kJ/kg]  At 303 K 
h2 = 503; //[kJ/kg]  At 503 K
h3 = 403; //[kJ/kg]  At 403 K
// for mixing chamber m1*[h1 + V1^2/2] + m2*[h2 + V2^2/2] = m3*[h3 + V3^2]+Q
// Also m1 = m2 = m and from mass balance m1+m2 = m3 = 2*m
// Final eq  =  [m*[h1 + V1^2/2 + h2 + V2^2/2] = 2*m*[h3 + V3^2/2]+Q]
V3 = sqrt(h1 + V1^2/(2*1000) + h2 + V2^2/(2*1000) - 2*h3); //[m/s]
// For nozzle mass flow rate remain constant so final equation is 
// m3*[h3 + V3^2/2] = m3*[h4 + V4^2/2]
h4 = h1;
V4 = sqrt(2*1000*[h3 + V3^2/(2*1000)-h4]);
disp('Velocity of air stream leaving the nozzle at 30°C = ' , V4 , 'm/s')
// The answer vary due to round off error 
