//Example 5.4
//Estimate heat transfer rate in compressor and cooler
clear
clc
p1 = 1; // [bar]
P1 = 100; //[kPa]
t1 = 25; //[°C]
V1 = 2.5; // [m^3/min]  volumetric flow rate of air
p2 = 2; // [bar]
t2 = 120; //[°C]
t3 = 27; //[°C]
dW_by_dt_1 = -5;  //[kW]  Work input required for compressor
T1 = t1 + 273; //[K]
T2 = t2 + 273; //[K]
T3 = t3 + 273; //[K]
R = 0.287; 
v1 = (R*T1)/P1; //[m^3/kg]
m = V1/v1; //[kg/min]   mass flow rate in kg/min
m2 = m/60; //[kg/s]    mass flow rate in kg/s
//(i) Estimate heat transfer rate in compressor
cp = 1.005;  //[kJ/kg K]
h1_h2 = cp*(T1 - T2); // [kJ/kg]  
Q1 = dW_by_dt_1 - m2*[h1_h2]; //[kJ/s] //heat transfer rate in compressor
disp('Heat transfer rate in compressor = ', Q1 , 'kJ/s' )
//(ii) Estimate  heat transfer rate in cooler
h2_h3 = cp*(T2-T3); //[kJ/kg]
dW_by_dt_2 = 0; // since no work is involved in cooler dW/dt = 0
Q2 = dW_by_dt_2 - m2*(h2_h3) ;  // heat transfer rate in cooler
disp('Heat transfer rate in cooler = ', Q2 , 'kJ/s')
//Answer vary due to round off error
