//Example 5.2
//Estimate the power output for steady flow conditions
clear
clc
//At turbine inlet
p1 = 110; //[bar]
h1 = 2900; //[kJ/kg]
V1 = 36; //[m/s]
z1 = 3.3; //[m]
//At turbine outlet
p2 = 30; //[kPa]
h2 = 2490; //[kJ/kg]
V2 = 110; //[m/s]
z2 = 0; //[m]
heat_loss = -0.32; //[kJ/s]  rate of heat loss(dQ/dt)
m = 0.393;  //[kg/s]
g = 9.8;  //[m/s^2]
P = m*[(h1-h2) + (V1^2 - V2^2)/(2*1000 )+ ((z1-z2)*g)/1000] + heat_loss;//[kW]
disp('Power output of turbine = ', P , 'kW')
