//Example 4.6
//Determine dryness fraction and maximum moisture 
clear
clc
p1= 10; //[MPa]
p2 = 0.05; //[MPa]
t = 100; //[°C]
//(i) Calculate dryness fraction of steam
h2 = 2682; //[kJ/kg]    when p2 = 0.05 MPa and t = 100°C from superheated steam tables
hf1 = 1407; //[kJ/kg]   at p1 = 10 MPa
hfg1 = 1317; //[kJ/kg]   at p1 = 10MPa
h1 = h2;  //for throttling process   (h1 = h2 = hf1 + x*hfg1)
x = (h2 - hf1)/hfg1; 
dryness_fraction = x*100; //[%]
disp('Quality (dryness fraction) of steam = ', dryness_fraction,'%')
//(ii) Calculate the maximum moisture 
t2 = 5; //[°C]   superheat reuired after throttling
t_sat = 81; //[°C]    at p2=0.05 MPa
T = t_sat + t2; //[°C] 
//from superheated steam tables 
h3 = 2660; //[kJ/kg]  
h4 = h3; //[kJ/kg]
hf4 = hf1;//[kJ/kg]
hfg4 = hfg1;//[kJ/kg]
// h4 = hf4 + x4*hfg4
x4 = (h4-hf4)/hfg4;  
max_moisture = (1-x4)*100;
disp('Maximum moisture allowed is', max_moisture , '%')
//The answer vary due to round off error
