//Example 4.4
//Determine power of turbine and diameter at inlet and exit
clear 
clc
m = 2;  //  [kg/s]
V1 = 100; //[m/s]    velocity of steam at inlet
V2 = 50;  //[m/s]    velocity of steam at exit
z1_z2 = 3; //[m]   difference in height of inlet and exit(z1-z2)
//From superheated steam table
//At state 1 at 20 bar and 250°C
h1 = 2902.5;  //[kJ/kg]
s1 = 6.5453;  //[kJ/kg K]
v1 = 0.11144  //[m^3/kg]
//At state 2 at 0.2 bar and 5% moisture
hf2 = 251.40; //[kJ/kg]
hfg2 = 2358.3;  //[kJ/kg]
vf2 = 0.00101; //[m^3/kg]
sf2 = 7.64;  //[kJ/kg]
x = 0.95; // Quality or drynes fraction
h2 = hf2 + x*hfg2; //[kJ/kg]   enthalpy at state 2
q = -10; //[kJ/s]  rate of heat loss(dQ/dt)
g = 9.8; //[m/s^2]
//(i) Determine power of turbine when heat loss is at rate of 10 kJ/s
P = m*[(h1 - h2) + (V1^2 - V2^2)/(2*1000) + (z1_z2)*g/1000] + q;//[kW] power(dW/dt)
disp('Power of the turbine' , P , ' kW')
//(ii) Determine the diameters at inlet and exit
A1 = (m*v1)/V1; //[m^2]   inlet area 
v2 = 7.26; //[m^3/kg]
A2 = (m*v2)/V2;  //[m^2]    exit area
d1 = sqrt((A1*4)/%pi); //[m]   inlet diameter
d2 = sqrt((A2*4)/%pi);  //[m]   exit diameter
disp('Diameter at inlet, d1 =  ' , d1*100 , 'cm')
disp('Diameter at exit, d2 = ' , d2*100 , 'cm')
//Answer vary due to round off error
