//Example 14.5
//Determine the specific humidity
clear
clc
p = 101.32; //[kPa]
T1 = 273+20; //[K]
T2 = 273 + 25; //[K]
φ1 = 0.25; // Relative humidity of 1st stream
φ2 = 0.75; //Relative humidity of 2nd stream
ps1 = 2.339; //[kPa]
ps2 = 3.169; //[kPa]
pw1 = φ1*ps1; //[kPa]
ω1 = (0.622*pw1)/(p - pw1); 
pw2 = φ2*ps2; //[kPa]
ω2 = (0.622*pw2)/(p - pw2);
v1 = 20; //[m^3/min]
v2 = 25; //[m^3/min]
Ra = 0.287; 
pa1 = p - pw1;//[kPa]
pa2 = p - pw2; //[kPa]
ma1 = (pa1*v1)/(Ra*T1); //[kg/min]
ma2 = (pa2*v2)/(Ra*T2); //[kg/min]
ω3 = (ω1*ma1 + ω2*ma2)/(ma1 + ma2); //kg/kg of dry air
disp('Specific humidity = ',ω3,'kg/kg of dry air')
