//Example 13.4
//Determine the saturation pressure of the refrigerant R 134a
clear
clc
//The Clausius-Clapeyron equation for determing saturation pressure is
// log(p2/p1) = (hfg/R)*( (T2 - T1)/T1*T2 )
T1 = 273 - 50;//[K]
T2 = 273 - 40; //[K]
hfg = 225.86; //[kJ/kg K] From R-134a tables at -40°C
R = 0.08149; //[kJ/kg K]
p2 = 51.25; //[kPa]
ln_p1 = log(p2) - [(hfg/R)*( (T2 - T1)/(T1*T2) )];
p1 = exp(ln_p1); //[kPa]
disp('Saturation pressure of the refrigerant R-134a at -50°C =',p1,'kPa')
