//Example 12.6
//Find  total exergy destruction and in each process and efficiency
clear
clc
//From properties table of R-134 a
T1 = 273 - 26.4; //[K]
h1 = 234.44; //[kJ/kg]
s1 = 0.9518; //[kJ/kg k]
P2 = 1017.1; //[kPa]
s2_1 = s1; //[kJ/kg K]
h2_1 = 281.32; //[kJ/kg]
P3 = P2; //[kPa]
h3 = 108; //[kJ/kg]
s3 = 0.392; //[kJ/kg K]
P4 = 100; //[kPa]
h4 = h3; //[kJ/kg]
s4 = 0.437; //[kJ/kg K]
m = 0.08; //[kg/s]
T0 = 273 + 27; //[K] surrounding temperature 
T2 = 273 - 10; //[K]
eta_c = 0.85; // Isentropic efficienccy
h2 = [(h2_1 - h1)/eta_c] + h1; //[kJ/kg]
s2 = 0.973; ///[kJ/kg K] at h2 and P2
Q1 = m*(h2 - h3); //[kW]
Q2 =  m*(h1 - h4); //[kW]
W_in = m*(h2 - h1); //[kW]
//(i) Find exergy destruction in each process
X_destroyed_12 = T0*m*(s2 - s1); //[kW]
X_destroyed_23 = T0*[m*(s3 - s2) + (Q1/300)]; //[kW]
X_destroyed_34 = T0*m*(s4 - s3); //[kW]
X_destroyed_41 = T0*[m*(s1 - s4) - (Q2/T2)]; //[kW]
disp('Exergy destruction in process 1-2 =',X_destroyed_12,'kW')
disp('Exergy destruction in process 2-3 =',X_destroyed_23,'kW')
disp('Exergy destruction in process 3-4 =',X_destroyed_34,'kW')
disp('Exergy destruction in process 4-1 =',X_destroyed_41,'kW')
//(ii) Find second-law efficiency
W_min_in = Q2*[(T0 - T2)/T2]; //[kW]
eta_pi = (W_min_in/W_in)*100; //[%]
disp('Second-law efficiency =',eta_pi,'%')
//(iii) Find Total exergy destruction
X_destroyed=X_destroyed_12+X_destroyed_23+X_destroyed_34+X_destroyed_41;//[kW]
disp('Total exergy destruction =',X_destroyed,'kW')
// The answer of exergy destruction in process 2-3 is provided wrong in textbook due to this value of total exergy destruction differs